/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.NlothsGift;
import java.util.ArrayList;
import java.util.Collections;

public class Nloth
extends AbstractImageEvent {
    public static final String ID = "N'loth";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("N'loth");
    public static final String NAME = Nloth.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = Nloth.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = Nloth.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String DIALOG_2 = DESCRIPTIONS[1];
    private static final String DIALOG_3 = DESCRIPTIONS[2];
    private int screenNum = 0;
    private AbstractRelic choice1;
    private AbstractRelic choice2;

    public Nloth() {
        super(NAME, DIALOG_1, "images/events/nloth.jpg");
        ArrayList<AbstractRelic> relics = new ArrayList<AbstractRelic>();
        relics.addAll(AbstractDungeon.player.relics);
        Collections.shuffle(relics);
        this.choice1 = (AbstractRelic)relics.get(0);
        this.choice2 = (AbstractRelic)relics.get(1);
        GenericEventDialog.setDialogOption(OPTIONS[0] + this.choice1.name + OPTIONS[1]);
        GenericEventDialog.setDialogOption(OPTIONS[0] + this.choice2.name + OPTIONS[1]);
        GenericEventDialog.setDialogOption(OPTIONS[2]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(DIALOG_2);
                        this.logMetric("Traded a " + this.choice1.relicId);
                        AbstractDungeon.player.loseRelic(this.choice1.relicId);
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, new NlothsGift());
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 1: {
                        GenericEventDialog.updateBodyText(DIALOG_2);
                        this.logMetric("Traded a " + this.choice2.relicId);
                        AbstractDungeon.player.loseRelic(this.choice2.relicId);
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, new NlothsGift());
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 2: {
                        this.logMetric("Ignored");
                        GenericEventDialog.updateBodyText(DIALOG_3);
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                }
                GenericEventDialog.updateBodyText(DIALOG_3);
                this.screenNum = 1;
                GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                GenericEventDialog.clearRemainingOptions();
                break;
            }
            case 1: {
                this.openMap();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

